<?php
include("templates/headers/inc.php");

// If we have a session, redirect !
if(!$_SESSION || !isset($_SESSION["USER_ID"])) {
	header("Location: index.php?action=need_log_in");
	exit;
}

$user_id = $_SESSION["USER_ID"];

// Get website config
$site_config = $dbh->prepare("SELECT * FROM config WHERE config_name IN ('website_name','website_tagline','ads_code')");
$site_config->execute();

$config_array = array();

while($config = $site_config->fetch(PDO::FETCH_ASSOC)) {
	$config_array[$config["config_name"]] = $config["config_value"];
}

$website_name = $config_array["website_name"];
$website_tagline = $config_array["website_tagline"];
$ads_code = $config_array["ads_code"];

?>
<!doctype html>
<html lang="en">
	<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
		
		<link href="https://fonts.googleapis.com/css?family=Baloo+Bhai" rel="stylesheet">
		
		<!-- Bootstrap CSS -->
		<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">
		<link rel="stylesheet" href="css/emoji.css">
		<link rel="stylesheet" href="css/jquery.toast.min.css">
		<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.2.0/css/all.css" integrity="sha384-hWVjflwFxL6sNzntih27bfxkr27PmbbK/iSvJ+a4+0owXq79v+lsFkW54bOGbiDQ" crossorigin="anonymous">
		<link rel="stylesheet" href="css/custom.css?v=<?php echo mt_rand(0,9999); ?>">
		
		<title><?php echo $website_name; ?> - Profile</title>
		
		<!-- Facebook Pixel Code -->
		<script>
		  !function(f,b,e,v,n,t,s)
		  {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
		  n.callMethod.apply(n,arguments):n.queue.push(arguments)};
		  if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
		  n.queue=[];t=b.createElement(e);t.async=!0;
		  t.src=v;s=b.getElementsByTagName(e)[0];
		  s.parentNode.insertBefore(t,s)}(window, document,'script',
		  'https://connect.facebook.net/en_US/fbevents.js');
		  fbq('init', '699020746857913');
		  fbq('track', 'PageView');
		</script>
		<noscript><img height="1" width="1" style="display:none"
		  src="https://www.facebook.com/tr?id=699020746857913&ev=PageView&noscript=1"
		/></noscript>
		<!-- End Facebook Pixel Code -->
	</head>
	<body>
		
		<header>
			<div class="site_title">
				TestMyFriends
			</div>
			<div class="site_tagline"> 
				How Well Do Your Friends Know You?
			</div>
		</header>
		
		
		<div class="container">
			
			<div class="col-md-8 offset-md-2">
									
				<div class="menu">
				
					<div class="row">

						<div class="col-md-4 col-sm-4">
							<div class="menu-item" data-url="/home.php">
								
								<div class="menu-icon">
									<i class="em em-computer"></i>
								</div>
								
								<div class="menu-title">
									My Quiz
								</div>
								
							</div>
						</div>
						
						<div class="col-md-4 col-sm-4">
							<div class="menu-item" data-url="/friends.php">
								
								<div class="menu-icon">
									<i class="em em-blush"></i>
								</div>
								
								<div class="menu-title">
									My Friends
								</div>
								
							</div>
						</div>
						
						<div class="col-md-4">
							<div class="menu-item" data-url="/logout.php">
								
								<div class="menu-icon">
									<i class="em em-zipper_mouth_face"></i>
								</div>
								
								<div class="menu-title">
									Logout
								</div>
								
							</div>
						</div>
				
					</div>
					
				</div>
				
				<div class="row">
					
					<div class="inner-container">
						<center>
							<a class="btn btn-primary btn-create-quiz" href="create-quiz.php"><i class="em em-computer"></i> Create a Quiz</a>
						</center>
						<br />		
						<div class="quiz_list_container">
							<a class="btn btn-primary btn-block" href="logout.php">Logout</a>
						</div>
					</div>
									
				</div>
			
			</div>
			
			
		</div>
		
		<footer>
			<div class="copyright-container">
				© Copyright <?php echo date("Y"); ?> TestMyFriends 
			</div>
		</footer>
		
		<!-- Optional JavaScript -->
		<!-- jQuery first, then Popper.js, then Bootstrap JS -->
		<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js" integrity="sha384-ZMP7rVo3mIykV+2+9J3UJ46jBk0WLaUAdn689aCwoqbBJiSnjAK/l8WvCWPIPm49" crossorigin="anonymous"></script>
		<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js" integrity="sha384-ChfqqxuZUCnJSK3+MXmPNIyE6ZbWh2IMqE241rYiqJxyMiZ6OW/JmZQ5stwEULTy" crossorigin="anonymous"></script>
		<script src="js/jquery.toast.min.js" type="text/javascript"></script>
		<script src="js/jquery.cookie.js" type="text/javascript"></script>
	
		<script type="text/javascript">
		
			$(document).ready(function() {
				
				$(".menu-item").click(function(e) {
					
					e.preventDefault();
					
					window.location = $(this).attr("data-url");
					
				});
								
				
				
				function showError(msg) {
					$.toast({
						text: msg,
						bgColor : '#e74c3c',
						textColor : '#fff', 
						position : 'top-right'
					});
				}
				
			});
			
		</script>
		<!-- Global site tag (gtag.js) - Google Analytics -->
		<script async src="https://www.googletagmanager.com/gtag/js?id=UA-37805539-65"></script>
		<script>
		  window.dataLayer = window.dataLayer || [];
		  function gtag(){dataLayer.push(arguments);}
		  gtag('js', new Date());
		
		  gtag('config', 'UA-37805539-65');
		</script>
	</body>
</html>